
close all
clear all

% cd('C:\Users\aat1f15\Documents\Work\My Papers & Conf Presentations\DGON 2020\Presentation\Presentation Pics')
% open('Light Source Spectrum v2.fig')
% 
% ax = gca;
% ax.FontSize = 14;
% ax.XLabel.FontWeight = 'bold';
% ax.YLabel.String = 'Power (dBm)';
% ax.YLabel.FontWeight = 'bold';
% ax.YLim = [-80 -20];
% 
% lins = findobj(ax,'type','line');
% wave_nm = lins(1).XData;
% P = lins(1).YData;
% P_mW = 10.^(P./10);
% mean_wave_nm = center_of_mass(wave_nm,P_mW);
% max_pow = max(P);
% midpt = 10*log10(0.5);
% norm_P = P-max_pow;
% over_inds = find(norm_P>midpt);
% fwhm_nm = wave_nm(over_inds(end)) - wave_nm(over_inds(1));

mean_wave_nm = 1550; % MITANI Mean Wavelength (SLD)
fwhm_nm = 50;  % MITANI SLD Bandwidth

% wave = wave_nm.*1e-9;
fwhm = fwhm_nm.*1e-9;
mean_wave = mean_wave_nm.*1e-9;

c = 299792458; %m/sec

% [coh_lin, coh_phase_deg, dist_vec, time_vec] = interpolate_coherence_from_spec(wave_nm,P_mW);

% figure
% coh = 10.*log10(coh_lin);
% plot(time_vec,coh);
% ax = gca;
% ylim = ax.YLim; 
% ax.XLim = [0 ax.XLim(2)]; 
% hold on

% inv_bw = (mean_wave).^2./(2.*c.*fwhm); %sec 
inv_bw = (mean_wave).^2./(2.*c.*fwhm); %sec 
plot([inv_bw inv_bw],ylim,'r');



% L = 153*7; % Total length (MCIFOG #1)
% D = 0.1025; %mean coil diam (MCIFOG #1)

% L = 153*7; % Total length (MCIFOG #1)
% D = 0.1025; %mean coil diam (MCIFOG #1)

L = 823.8; % MITANI 10.1109/JLT.2019.2934992
D = 0.13; % MITANI 10.1109/JLT.2019.2934992

% mean_wave = 1.54e-6;
% fwhm = 2e-9;

% mean_wave = 0.83e-6;
% fwhm = 32.7e-9;
% inv_bw = (mean_wave).^2./(2.*c.*fwhm); %sec 

% L = 1000;
% D = 0.32;
SF = 2*pi*L*D./(mean_wave.*c) %scale factor in sec
inv_SF_hr = 1./SF.*3600;
M = pi./2;
% M = 1.8;
prefactor = (1+ besselj(0,M))./besselj(1,M); %unitless

% Prefactor and computation from equation 3 in 
% [1] W. K. Burns, R. P. Moeller, and A. Dandridge, Excess noise in fiber gyroscope sources, 
% IEEE Photonics Technol. Lett., vol. 2, no. 8, pp. 606608, Aug. 1990, doi: 10.1109/68.58063.

RIN_ARW = inv_SF_hr.*prefactor.*sqrt(inv_bw./3600).*180./pi





